/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8282.DeviceView;

import ibm.nways.jdm.common.OID;
import ibm.nways.jdm8282.DeviceView.AtmConnector;
import ibm.nways.jdm8282.DeviceView.Chassis8282;
import ibm.nways.jdm8282.DeviceView.ChassisLike;
import ibm.nways.jdm8282.DeviceView.ChassisUnknown;
import ibm.nways.jdm8282.DeviceView.ConnectorLike;
import ibm.nways.jdm8282.DeviceView.FactoryLike;
import ibm.nways.jdm8282.DeviceView.OptionalAtmCard;
import ibm.nways.jdm8282.DeviceView.OptionalCardLike;
import ibm.nways.jdm8282.DeviceView.OptionalPortCard;
import ibm.nways.jdm8282.DeviceView.Port;
import ibm.nways.jdm8282.DeviceView.ResetButton;
import ibm.nways.jdm8282.DeviceView.TtyConnector;
import java.io.Serializable;

public class Factory
implements FactoryLike {
    private static final FactoryLike instance = new Factory();

    public ConnectorLike createResetButton() {
        return new ResetButton();
    }

    public static FactoryLike getInstance() {
        return instance;
    }

    public ChassisLike createChassis(Serializable serializable) {
        String string;
        if (serializable instanceof OID && (string = serializable.toString()).equals("1.3.6.1.4.1.2.6.81")) {
            return new Chassis8282();
        }
        return new ChassisUnknown();
    }

    public OptionalCardLike createOptionalPortCard() {
        return new OptionalPortCard();
    }

    public OptionalCardLike createOptionalAtmCard() {
        return new OptionalAtmCard();
    }

    public ConnectorLike createAtm() {
        return new AtmConnector();
    }

    public ConnectorLike createTty() {
        return new TtyConnector();
    }

    public ConnectorLike createPort(int n) {
        return new Port(n);
    }
}

